"use client";

import { Card, CardContent } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { Briefcase, Code, Headphones, Puzzle } from "lucide-react";
import { motion } from "framer-motion";

interface ServicesProps {
  dict: any;
}

export function Services({ dict }: ServicesProps) {
  const services = [
    {
      icon: Briefcase,
      title: dict.items.consulting.title,
      description: dict.items.consulting.desc,
      color: "bg-brand-primary",
      iconBg: "bg-brand-primary/10",
      iconColor: "text-brand-primary",
    },
    {
      icon: Puzzle,
      title: dict.items.integration.title,
      description: dict.items.integration.desc,
      color: "bg-brand-secondary",
      iconBg: "bg-brand-secondary/10",
      iconColor: "text-brand-secondary",
    },
    {
      icon: Headphones,
      title: dict.items.support.title,
      description: dict.items.support.desc,
      color: "bg-accent-purple",
      iconBg: "bg-accent-purple/10",
      iconColor: "text-accent-purple",
    },
    {
      icon: Code,
      title: dict.items.customDev.title,
      description: dict.items.customDev.desc,
      color: "bg-accent-orange",
      iconBg: "bg-accent-orange/10",
      iconColor: "text-accent-orange",
    },
  ];

  return (
    <section id="services" className="py-20 md:py-32 bg-gray-50 relative overflow-hidden">
      {/* Background decoration */}
      <div className="absolute top-0 right-0 w-1/3 h-1/3 bg-brand-primary/5 rounded-full blur-3xl"></div>
      <div className="absolute bottom-0 left-0 w-1/3 h-1/3 bg-brand-secondary/5 rounded-full blur-3xl"></div>
      
      <div className="container px-4 md:px-6 relative z-10">
        <div className="max-w-3xl mx-auto text-center mb-16">
          <h2 className="text-3xl md:text-5xl font-bold tracking-tighter mb-4">
            {dict.title}
          </h2>
          <p className="text-lg md:text-xl text-text-secondary">
            {dict.subtitle}
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-6 max-w-7xl mx-auto">
          {services.map((service, index) => {
            const Icon = service.icon;
            return (
              <motion.div
                key={index}
                initial={{ opacity: 0, y: 20 }}
                whileInView={{ opacity: 1, y: 0 }}
                transition={{ delay: index * 0.1 }}
                viewport={{ once: true }}
              >
                <Card className="h-full hover:shadow-lg transition-shadow border-2 hover:border-brand-primary/20">
                  <CardContent className="p-6 space-y-4">
                    <div className={`w-14 h-14 rounded-xl ${service.iconBg} flex items-center justify-center`}>
                      <Icon className={`w-7 h-7 ${service.iconColor}`} />
                    </div>
                    <h3 className="text-xl font-semibold">{service.title}</h3>
                    <p className="text-text-secondary leading-relaxed">
                      {service.description}
                    </p>
                  </CardContent>
                </Card>
              </motion.div>
            );
          })}
        </div>
      </div>
    </section>
  );
}
