"use client";

import { useState } from "react";
import { Button } from "@/components/ui/button";
import { Send } from "lucide-react";
import { Locale } from "@/lib/i18n";

interface ContactFormProps {
  lang: Locale;
  dict: {
    name: string;
    email: string;
    company: string;
    message: string;
    submit: string;
    success: string;
  };
}

export function ContactForm({ lang, dict }: ContactFormProps) {
  const [formState, setFormState] = useState({
    name: "",
    email: "",
    company: "",
    message: "",
  });
  const [isSubmitted, setIsSubmitted] = useState(false);

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault();
    console.log("Form submitted:", formState);
    setIsSubmitted(true);
    setTimeout(() => {
      setIsSubmitted(false);
      setFormState({ name: "", email: "", company: "", message: "" });
    }, 3000);
  };

  const formTitle = 
    lang === "en" ? "Send us a message" :
    lang === "ru" ? "Отправьте нам сообщение" :
    "Bizga xabar yuboring";

  return (
    <div>
      <h2 className="text-2xl md:text-3xl font-bold mb-6">
        {formTitle}
      </h2>
      <form onSubmit={handleSubmit} className="space-y-4">
        <div>
          <label htmlFor="name" className="block text-sm font-medium mb-2">
            {dict.name}
          </label>
          <input
            type="text"
            id="name"
            required
            className="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-brand-primary focus:border-transparent"
            value={formState.name}
            onChange={(e) => setFormState({ ...formState, name: e.target.value })}
          />
        </div>

        <div>
          <label htmlFor="email" className="block text-sm font-medium mb-2">
            {dict.email}
          </label>
          <input
            type="email"
            id="email"
            required
            className="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-brand-primary focus:border-transparent"
            value={formState.email}
            onChange={(e) => setFormState({ ...formState, email: e.target.value })}
          />
        </div>

        <div>
          <label htmlFor="company" className="block text-sm font-medium mb-2">
            {dict.company}
          </label>
          <input
            type="text"
            id="company"
            className="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-brand-primary focus:border-transparent"
            value={formState.company}
            onChange={(e) => setFormState({ ...formState, company: e.target.value })}
          />
        </div>

        <div>
          <label htmlFor="message" className="block text-sm font-medium mb-2">
            {dict.message}
          </label>
          <textarea
            id="message"
            required
            rows={5}
            className="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-brand-primary focus:border-transparent"
            value={formState.message}
            onChange={(e) => setFormState({ ...formState, message: e.target.value })}
          />
        </div>

        <Button type="submit" className="w-full" size="lg">
          <Send className="w-4 h-4 mr-2" />
          {dict.submit}
        </Button>

        {isSubmitted && (
          <div className="p-4 bg-green-50 border border-green-200 rounded-lg text-green-800 text-center">
            {dict.success}
          </div>
        )}
      </form>
    </div>
  );
}
