# RSaSh Lab Corporate Website

Official corporate website for RSaSh Lab, showcasing the ecosystem of enterprise products (Flow, Fleet, Travel, CorpCloth, Gravion).

## 🚀 Quick Start

1. **Install Dependencies**
   ```bash
   npm install
   ```

2. **Run Development Server**
   ```bash
   npm run dev
   ```
   Open [http://localhost:3000](http://localhost:3000) with your browser.

## 🛠 Tech Stack

- **Framework:** Next.js 14 (App Router)
- **Language:** TypeScript
- **Styling:** Tailwind CSS + CSS Variables (Design Tokens)
- **Animation:** Framer Motion
- **Icons:** Lucide React
- **I18n:** Built-in Middleware (en, ru, uz)

## 📂 Project Structure

- `app/[lang]`: Localized pages (File-based routing)
- `components/ui`: Reusable design system primitives (Button, Badge, Card)
- `components/sections`: Page sections (Hero, ProductEcosystem, CTA)
- `dictionaries`: Translation files
- `styles/globals.css`: CSS Variables for the Design System
- `public/logos`: Product logos and assets

## 🎨 Design System

The project uses a strict set of design tokens defined in `styles/globals.css` and mapped in `tailwind.config.ts`.

- **Brand Primary:** Cyan 600 (`#0891B2`)
- **Product Colors:**
  - Flow: Cyan
  - Fleet: Orange
  - Travel: Emerald
  - Weave: Violet
  - Orbit: Cyan

## 🌐 Internationalization

Translations are managed in `lib/dictionaries.ts` (for this MVP phase) or JSON files in `dictionaries/`.
The middleware automatically handles locale detection and redirection.

---
© 2025 RSaSh Lab
